/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.sam.Formats;

import com.quantumdata.sam.Formats.FormatDvicComparator;
import com.quantumdata.sam.Formats.FormatHdmiComparator;
import com.quantumdata.sam.Formats.FormatStringComparator;
import com.quantumdata.sam.Formats.FormatType;
import com.quantumdata.sam.Formats.Formats;
import com.quantumdata.sam.Formats.VideoIDCode;
import com.quantumdata.sam.SignalAnalysisModule;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoadFormats {
    public static void main(String[] stringArray) throws JAXBException, FileNotFoundException {
        JAXBContext jAXBContext = JAXBContext.newInstance((Class[])new Class[]{Formats.class});
        Unmarshaller unmarshaller = jAXBContext.createUnmarshaller();
        Formats formats = (Formats)unmarshaller.unmarshal(LoadFormats.class.getClassLoader().getResourceAsStream("com/quantumdata/sam/Formats/formats.xml"));
        if (stringArray[0].equals("-s")) {
            int n;
            List<FormatType> list = formats.getFormat();
            for (n = 0; n < formats.getFormat().size(); ++n) {
                FormatType formatType = list.get(n);
                formatType.setHres(formatType.getHres() * formatType.getNcpp());
                formatType.setHtot(formatType.getHtot() * formatType.getNcpp());
                formatType.setHspd(formatType.getHspd() * formatType.getNcpp());
                formatType.setHspw(formatType.getHspw() * formatType.getNcpp());
            }
            LoadFormats.sortFormatList(formats.getFormat(), stringArray[1]);
            System.out.format("%1$32s%2$15s%3$6s%4$6s%5$6s%6$6s%7$6s%8$6s%9$10s%10$6s%11$6s%12$6s%13$6s%14$6s%15$6s%n", "DVIC", "NAME", "NCPP", "SCAN", "HRES", "VRES", "VTOT", "HTOT", "HRAT", "HSPW", "VSPW", "HSPD", "VSPD", "HSPP", "VSPP");
            for (n = 0; n < formats.getFormat().size(); ++n) {
                LoadFormats.DumpFormat(formats.getFormat().get(n));
            }
        } else {
            System.out.println("usage: java LoadFormats -s \"name\" | \"dvic\"");
        }
        LoadFormats.CreateFormatTableDotJava(formats.getFormat());
    }

    public static Formats loadFormats() throws JAXBException {
        Object object;
        Formats formats = null;
        JAXBContext jAXBContext = JAXBContext.newInstance((Class[])new Class[]{Formats.class});
        Unmarshaller unmarshaller = jAXBContext.createUnmarshaller();
        if (SignalAnalysisModule.runningAsApplet) {
            try {
                object = new URL(SignalAnalysisModule.sam.getCodeBase() + "/formats.xml");
                formats = (Formats)unmarshaller.unmarshal(((URL)object).openStream());
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace();
            }
            catch (JAXBException jAXBException) {
                jAXBException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        } else {
            formats = (Formats)unmarshaller.unmarshal(LoadFormats.class.getClassLoader().getResourceAsStream("com/quantumdata/sam/Formats/formats.xml"));
        }
        object = formats.getFormat();
        for (int i = 0; i < formats.getFormat().size(); ++i) {
            FormatType formatType = (FormatType)object.get(i);
            formatType.setHres(formatType.getHres() * formatType.getNcpp());
            formatType.setHtot(formatType.getHtot() * formatType.getNcpp());
            formatType.setHspd(formatType.getHspd() * formatType.getNcpp());
            formatType.setHspw(formatType.getHspw() * formatType.getNcpp());
        }
        Collections.sort(formats.getFormat(), new FormatHdmiComparator());
        return formats;
    }

    private static void sortFormatList(List<FormatType> list, String string) {
        if (string.equalsIgnoreCase("name")) {
            Collections.sort(list, new FormatStringComparator());
        } else if (string.equalsIgnoreCase("dvic")) {
            Collections.sort(list, new FormatDvicComparator());
        } else if (string.equalsIgnoreCase("hdmi")) {
            Collections.sort(list, new FormatHdmiComparator());
        }
    }

    private static void CreateFormatTableDotJava(List<FormatType> list) throws FileNotFoundException {
        PrintWriter printWriter = new PrintWriter("com/quantumdata/sam/Formats/FormatTable.java");
        printWriter.println("package com.quantumdata.sam.Formats;");
        printWriter.println("import java.util.List;");
        printWriter.println("public class FormatTable { ");
        printWriter.println("private static Formats formats;");
        printWriter.println("static {");
        printWriter.println("formats = new Formats();");
        printWriter.println("List<FormatType> ftl = formats.getFormat();");
        printWriter.println("FormatType ft;\n\n");
        for (int i = 0; i < list.size(); ++i) {
            FormatType formatType = list.get(i);
            printWriter.println("ft = new FormatType();");
            printWriter.println("ft.setName(\"" + formatType.getName() + "\");");
            printWriter.println("ft.setDvic(" + formatType.getDvic() + ");");
            printWriter.println("ft.setScan(" + formatType.getScan() + ");");
            printWriter.println("ft.setHtot(" + formatType.getHtot() + ");");
            printWriter.println("ft.setVtot(" + formatType.getVtot() + ");");
            printWriter.println("ft.setHres(" + formatType.getHres() + ");");
            printWriter.println("ft.setVres(" + formatType.getVres() + ");");
            printWriter.println("ft.setHspw(" + formatType.getHspw() + ");");
            printWriter.println("ft.setVspw(" + formatType.getVspw() + ");");
            printWriter.println("ft.setHspd(" + formatType.getHspd() + ");");
            printWriter.println("ft.setVspd(" + formatType.getVspd() + ");");
            printWriter.println("ft.setHspp(" + formatType.getHspp() + ");");
            printWriter.println("ft.setHvpd(" + formatType.getHvpd() + ");");
            printWriter.println("ft.setVspp(" + formatType.getVspp() + ");");
            printWriter.println("ft.setHrat(" + formatType.getHrat() + ");");
            printWriter.println("ft.setFrat(" + formatType.getFrat() + ");");
            printWriter.println("ft.setPrat(" + formatType.getPrat() + ");");
            printWriter.println("ft.setNcpp(" + formatType.getNcpp() + ");");
            printWriter.println("ftl.add(ft);");
        }
        printWriter.println("}");
        printWriter.println("public static Formats getFormats()");
        printWriter.println("{");
        printWriter.println(" return formats;");
        printWriter.println("}}");
        printWriter.flush();
        printWriter.close();
    }

    private static void DumpFormat(FormatType formatType) {
        System.out.format("%1$32s", VideoIDCode.getVideoIDCodeString(formatType.getDvic()));
        System.out.format("%1$15s", formatType.getName());
        System.out.format("%1$6s", formatType.getNcpp());
        System.out.format("%1$6s", formatType.getScan());
        System.out.format("%1$6s", formatType.getHres());
        System.out.format("%1$6s", formatType.getVres());
        System.out.format("%1$6s", formatType.getVtot());
        System.out.format("%1$6s", formatType.getHtot());
        System.out.format("%1$10s", formatType.getHrat());
        System.out.format("%1$6s", formatType.getHspw());
        System.out.format("%1$6s", formatType.getVspw());
        System.out.format("%1$6s", formatType.getHspd());
        System.out.format("%1$6s", formatType.getVspd());
        System.out.format("%1$6s", formatType.getHspp());
        System.out.format("%1$6s%n", formatType.getVspp());
    }
}

